<?php
// relatorio_trimestral.php
include 'conexao.php';

// Locale para mês em português
setlocale(LC_TIME, 'pt_PT.UTF-8', 'pt_PT', 'pt_BR.UTF-8', 'portuguese');

$ano = $_GET['ano'] ?? date('Y');

// Inicializa arrays para armazenar os dados trimestrais
$dados_trimestrais = [];
$trimestres = [
    '1º Trimestre' => [1, 3],
    '2º Trimestre' => [4, 6],
    '3º Trimestre' => [7, 9],
    '4º Trimestre' => [10, 12]
];

// Preenche o array com os dados de cada trimestre
foreach ($trimestres as $nome => [$mes_inicio, $mes_fim]) {
    $sql_movimentos = $conn->prepare("
        SELECT tipo, SUM(valor) AS total
        FROM movimentos_diarios 
        WHERE MONTH(data) BETWEEN ? AND ? AND YEAR(data) = ?
        GROUP BY tipo
    ");
    $sql_movimentos->bind_param("iii", $mes_inicio, $mes_fim, $ano);
    $sql_movimentos->execute();
    $resultados = $sql_movimentos->get_result();

    $total_receitas = 0;
    $total_despesas = 0;

    while ($row = $resultados->fetch_assoc()) {
        if ($row['tipo'] == 'Entrada') {
            $total_receitas = $row['total'];
        } elseif ($row['tipo'] == 'Saída') {
            $total_despesas = $row['total'];
        }
    }

    $dados_trimestrais[] = [
        'nome' => $nome,
        'receitas' => $total_receitas,
        'despesas' => $total_despesas,
        'saldo' => $total_receitas - $total_despesas
    ];
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatório Trimestral</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #007bff;
            --secondary-color: #6c757d;
            --success-color: #28a745;
            --danger-color: #dc3545;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--light-color);
            color: var(--dark-color);
            margin: 0;
            padding: 20px;
        }

        .container {
            max-width: 900px;
            margin: 0 auto;
            background-color: #fff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .institutional-header {
            text-align: center;
            margin-bottom: 20px;
            font-size: 14px;
            line-height: 1.2;
        }
        .institutional-header img {
            width: 80px;
            margin-bottom: 10px;
        }
        .institutional-header h3, .institutional-header p {
            margin: 0;
        }
        .institutional-header h3 {
            font-weight: 600;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h2 {
            font-size: 24px;
            color: var(--primary-color);
            margin: 0;
        }
        .form-container {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            margin-bottom: 20px;
        }
        .form-container label {
            font-weight: 600;
        }
        .form-container input, .form-container button {
            padding: 8px 12px;
            border-radius: 6px;
            border: 1px solid #ccc;
            font-family: inherit;
        }
        .form-container button {
            background-color: var(--primary-color);
            color: #fff;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        .form-container button:hover {
            background-color: #0056b3;
        }
        .print-btn-container {
            text-align: right;
            margin-bottom: 20px;
        }
        .print-btn {
            padding: 10px 20px;
            font-size: 16px;
            background-color: var(--success-color);
            color: #fff;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        .print-btn:hover {
            background-color: #218838;
        }

        .table-container {
            width: 100%;
            overflow-x: auto;
        }
        table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            overflow: hidden;
            min-width: 600px;
        }
        th, td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }
        th {
            background-color: var(--dark-color);
            color: #fff;
            font-weight: 600;
        }
        tbody tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        @media print {
            body { background-color: #fff; padding: 0; }
            .container { box-shadow: none; border-radius: 0; padding: 0; border: none; }
            .form-container, .print-btn-container { display: none; }
            table { border-color: #000; }
            th, td { border-color: #000; }
            .institutional-header { display: block !important; }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="institutional-header">
        <img src="insignia/insignia.png" alt="Insígnia" />
        <h3>REPÚBLICA DE ANGOLA</h3>
        <p>Governo Provincial de Benguela</p>
        <p>Gabinete Provincial da Educação</p>
        <h3>COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK - CATUMBELA</h3>
    </div>

    <div class="header">
        <h2>RELATÓRIO FINANCEIRO TRIMESTRAL - <?= $ano ?></h2>
    </div>

    <div class="form-container">
        <form method="GET">
            <label>Ano: <input type="number" name="ano" value="<?= $ano ?>"></label>
            <button type="submit">Ver Relatório</button>
        </form>
    </div>

    <div class="print-btn-container">
        <button class="print-btn" onclick="window.print()">🖨️ Imprimir</button>
    </div>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Trimestre</th>
                    <th>Receitas (KZ)</th>
                    <th>Despesas (KZ)</th>
                    <th>Saldo (KZ)</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($dados_trimestrais as $trimestre): ?>
                    <tr>
                        <td><?= htmlspecialchars($trimestre['nome']) ?></td>
                        <td><?= number_format($trimestre['receitas'], 2, ',', '.') ?></td>
                        <td><?= number_format($trimestre['despesas'], 2, ',', '.') ?></td>
                        <td><?= number_format($trimestre['saldo'], 2, ',', '.') ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

</div>

</body>
</html>